/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.BlockIncubator;
import net.pavocado.exoticbirds.container.ContainerIncubator;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsTileEntities;
import net.pavocado.exoticbirds.item.ItemBirdEgg;

public class TileEntityIncubator
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public ItemStackHandler inventory = new ItemStackHandler(15){

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151065_br;
                }
            }
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBirdEgg;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityIncubator.this.func_70296_d();
        }
    };
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUp = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 15));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 15){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            CompoundNBT compoundnbt;
            ItemStack itemStack = super.extractItem(slot, amount, true);
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof ItemBirdEgg && (compoundnbt = itemStack.func_190925_c("eggValues")).func_74764_b("SpawnChance") && compoundnbt.func_74762_e("SpawnChance") >= 100) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }
    });
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 15));
    public int eggIncubateTime = -1;
    public int fuelBurnTimeLeft = -1;
    private boolean lastBurning = false;

    public TileEntityIncubator() {
        super((TileEntityType)ExoticBirdsTileEntities.EGG_INCUBATOR.get());
    }

    public boolean isBurning() {
        return this.fuelBurnTimeLeft > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean hasFuel = false;
        if (this.isBurning()) {
            hasFuel = true;
            --this.fuelBurnTimeLeft;
        }
        if (this.canSmelt()) {
            if (!hasFuel && this.burnFuel()) {
                hasFuel = true;
            }
            if (hasFuel) {
                if (this.eggIncubateTime == -1) {
                    this.eggIncubateTime = 500;
                } else {
                    --this.eggIncubateTime;
                    if (this.eggIncubateTime == 0) {
                        this.smeltItem();
                        this.eggIncubateTime = -1;
                    }
                }
            } else if (this.eggIncubateTime < 500) {
                this.eggIncubateTime = MathHelper.func_76125_a((int)(this.eggIncubateTime + 2), (int)0, (int)500);
            }
        } else {
            this.eggIncubateTime = -1;
        }
        if (this.lastBurning != hasFuel) {
            this.func_70296_d();
            BlockState newState = (BlockState)this.func_195044_w().func_206870_a((Property)BlockIncubator.field_220091_b, (Comparable)Boolean.valueOf(hasFuel));
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
            this.lastBurning = hasFuel;
        }
    }

    private boolean canSmelt() {
        int filledSpaces = 0;
        for (int i = 1; i < 15; ++i) {
            ItemStack currentEgg = this.inventory.getStackInSlot(i).func_77946_l();
            if (currentEgg.func_190926_b() || !(currentEgg.func_77973_b() instanceof ItemBirdEgg) || !ItemBirdEgg.canIncubate(currentEgg, 100)) continue;
            ++filledSpaces;
        }
        return filledSpaces > 0;
    }

    public void smeltItem() {
        for (int i = 1; i < 15; ++i) {
            ItemStack eggStack = this.inventory.getStackInSlot(i);
            if (eggStack.func_190926_b() || !(eggStack.func_77973_b() instanceof ItemBirdEgg)) continue;
            CompoundNBT compoundnbt = eggStack.func_190925_c("eggValues");
            if (compoundnbt.func_74764_b("SpawnChance")) {
                int spawnChance = compoundnbt.func_74762_e("SpawnChance");
                compoundnbt.func_74768_a("SpawnChance", Math.min(spawnChance + 10, 100));
            } else {
                compoundnbt.func_74768_a("SpawnChance", 40);
            }
            this.inventory.setStackInSlot(i, eggStack);
        }
    }

    private boolean burnFuel() {
        ItemStack fuelStack = this.inventory.getStackInSlot(0).func_77946_l();
        if (!fuelStack.func_190926_b()) {
            this.fuelBurnTimeLeft = 500;
            if (fuelStack.hasContainerItem()) {
                this.inventory.setStackInSlot(0, fuelStack.getContainerItem());
            } else {
                fuelStack.func_190918_g(1);
                this.inventory.setStackInSlot(0, fuelStack);
            }
            return true;
        }
        this.fuelBurnTimeLeft = -1;
        return false;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.lastBurning = this.isBurning();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.eggIncubateTime = compound.func_74762_e("incubateTime");
        this.fuelBurnTimeLeft = compound.func_74762_e("fuelBurnTimeLeft");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("incubateTime", this.eggIncubateTime);
        compound.func_74768_a("fuelBurnTimeLeft", this.fuelBurnTimeLeft);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((BlockIncubator)ExoticBirdsBlocks.EGG_INCUBATOR.get()).func_149739_a());
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerIncubator(windowId, inventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return this.inventoryCapabilityExternalSides.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternalUp.invalidate();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalSides.invalidate();
    }
}

